/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base.logging;

import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.SessionTracker;

public class VWTimerLog
extends ThreadLocal {
    private long beginTime = 0L;
    private long endTime = 0L;
    private long m_elapsed = 0L;
    private String m_location = null;
    private String m_initialLocation = null;
    protected String m_timerLogName = null;
    private static final String m_className = "VWTimerLog";

    public Object initialValue() {
        return new VWTimerLog();
    }

    private void init(String location, String timerLogName) {
        if (timerLogName != null) {
            this.m_timerLogName = timerLogName;
        }
        this.m_initialLocation = location;
        this.m_location = location;
        this.start();
    }

    public String getInitialLocation() {
        return this.m_initialLocation;
    }

    public void setInitialLocation(String location) {
        this.m_initialLocation = location;
    }

    public VWTimerLog(String location, String timerLogName) {
        this.init(location, timerLogName);
    }

    public VWTimerLog(String location) {
        this.init(location, null);
    }

    public VWTimerLog() {
    }

    public void setLocation(String s) {
        this.m_location = s;
    }

    public void setTimerLogName(String s) {
        if (s != null) {
            this.m_timerLogName = s;
        }
    }

    public boolean isLoggable() {
        if (this.m_timerLogName == null) {
            return false;
        }
        Logger logger = Logger.getLogger(this.m_timerLogName);
        return logger != null && logger.isFinest();
    }

    public void stop() {
        this.endTime = System.currentTimeMillis();
        this.m_elapsed = this.endTime - this.beginTime;
        if (this.m_timerLogName == null) {
            return;
        }
        Logger logger = Logger.getLogger(this.m_timerLogName);
        if (logger == null || !logger.isFinest()) {
            return;
        }
        logger.finest(m_className, this.m_location, "\tstops\t" + Long.toString(this.m_elapsed));
    }

    public long elapsed() {
        return this.m_elapsed;
    }

    public void reset() {
        this.endTime = 0L;
        this.beginTime = 0L;
    }

    public void start() {
        this.beginTime = System.currentTimeMillis();
        long idleTime = 0L;
        if (this.endTime != 0L) {
            idleTime = this.beginTime - this.endTime;
        }
        if (this.m_timerLogName == null) {
            return;
        }
        Logger logger = Logger.getLogger(this.m_timerLogName);
        if (logger == null || !logger.isFinest()) {
            return;
        }
        logger.finest(m_className, this.m_location, "\tstarts\t" + idleTime);
        SessionTracker.Check();
    }
}

